//
//  NotAvailableStudiesViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 15.02.23.
//

import UIKit

class NotAvailableStudiesViewController : UIViewController {
    
    @IBOutlet var notAvailableTextLabel: UILabel!
    
    @IBOutlet var availableStudiesLabel: UILabel!
    
    @IBOutlet var study_onlinebanking: UIButton!
    
    @IBOutlet var study_smartphoneusage: UIButton!
    
    @IBOutlet var study_healthapps: UIButton!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : Colors.carmine,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        notAvailableTextLabel.textColor = Colors.greyColor
        notAvailableTextLabel.font = Fonts.mediumFontWithSize(size: 16)
        notAvailableTextLabel.text = "Diese Studie ist aktuell noch nicht verfügbar."
        
        availableStudiesLabel.textColor = Colors.greyColor
        availableStudiesLabel.font = Fonts.mediumFontWithSize(size: 16)
        availableStudiesLabel.text = "Folgende Studien sind aktuell verfügbar:"
        
        Utilities.styleFilledButtonAvailableStudies_SmartphoneUsage(study_smartphoneusage)
        Utilities.styleFilledButtonAvailableStudies_OnlineBanking(study_onlinebanking)
        Utilities.styleFilledButtonAvailableStudies_HealthApps(study_healthapps)
        
        
    }
    
    
    @IBAction func study_onlinebanking(_ sender: Any) {
        let vc = self.storyboard?.instantiateViewController(withIdentifier: "TEST55")
        
        let layout = UICollectionViewFlowLayout()
        self.view.window?.rootViewController = AuthenticationScreenViewController(collectionViewLayout: layout)
        
        self.view.window?.rootViewController = vc
        self.view.window?.makeKeyAndVisible()
    }
    
    
    @IBAction func study_smartphoneusage(_ sender: Any) {
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveySmartphoneUsageNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .crossDissolve
        
        present(nc, animated: true)
    }
    
    
    @IBAction func study_healthapps(_ sender: Any) {
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "SurveyHealthAppsNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .crossDissolve
        
        present(nc, animated: true)
    }
    
    
    
    // https://stackoverflow.com/questions/24803178/navigation-bar-with-uiimage-for-title
    func navTitleWithImageAndText(titleText: String, imageName: String) -> UIView {

        // Creates a new UIView
        let titleView = UIView()

        // Creates a new text label
        let label = UILabel()
        label.text = titleText
        label.sizeToFit()
        label.center = titleView.center
        label.textAlignment = NSTextAlignment.center

        // Creates the image view
        let image = UIImageView()
        image.image = UIImage(named: imageName)

        // Maintains the image's aspect ratio:
        let imageAspect = image.image!.size.width / image.image!.size.height

        // Sets the image frame so that it's immediately before the text:
        let imageX = label.frame.origin.x - label.frame.size.height * imageAspect
        let imageY = label.frame.origin.y

        let imageWidth = label.frame.size.height * imageAspect
        let imageHeight = label.frame.size.height

        image.frame = CGRect(x: imageX, y: imageY, width: imageWidth, height: imageHeight)

        image.contentMode = UIView.ContentMode.scaleAspectFit

        // Adds both the label and image view to the titleView
        titleView.addSubview(label)
        titleView.addSubview(image)

        // Sets the titleView frame to fit within the UINavigation Title
        titleView.sizeToFit()

        return titleView

    }
    
}

